package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.MainActivity;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.activity.PodcastsByActivity;
import nemosofts.voxradio.activity.RadioByActivity;
import nemosofts.voxradio.adapter.home.AdapterHomeCategories;
import nemosofts.voxradio.adapter.home.AdapterHomeCountries;
import nemosofts.voxradio.adapter.home.AdapterHomePodcasts;
import nemosofts.voxradio.adapter.home.AdapterHomeTrending;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.fragment.online.FragmentCategories;
import nemosofts.voxradio.fragment.online.FragmentCountries;
import nemosofts.voxradio.fragment.online.FragmentLatest;
import nemosofts.voxradio.interfaces.InterAdListener;
import nemosofts.voxradio.interfaces.RewardAdListener;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;
import nemosofts.voxradio.utils.recycler.RecyclerItemClickListener;


@UnstableApi
public class AdapterSearch extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    Context context;
    Helper helper;
    SPHelper spHelper;
    List<ItemPost> arrayList;
    int clickPos = 0;

    private static final String TAG_CREDIT = "Your Total Credit (";

    private static final int VIEW_PROG = 0;
    private static final int VIEW_CATEGORIES = 1;
    private static final int VIEW_COUNTRIES = 2;
    private static final int VIEW_PODCASTS = 3;
    private static final int VIEW_RADIO = 4;

    AdapterHomeTrending adapterHomeRadio;

    public AdapterSearch(Context context, List<ItemPost> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        helper = new Helper(context, interAdListener);
        spHelper = new SPHelper(context);
    }

    public class CategoriesHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomeCategories adapterHomeCategories;
        TextView title;
        LinearLayout viewAll;

        CategoriesHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv.setLayoutManager(linearLayoutManager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class CountriesHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomeCountries adapterHomeCountries;
        TextView title;
        LinearLayout viewAll;

        CountriesHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv.setLayoutManager(linearLayoutManager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class PodcastsHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        AdapterHomePodcasts adapterHomePodcasts;
        TextView title;
        LinearLayout viewAll;

        PodcastsHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv.setLayoutManager(linearLayoutManager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    public class RadiosHolder extends RecyclerView.ViewHolder {

        RecyclerView rv;
        TextView title;
        LinearLayout viewAll;

        RadiosHolder(View view) {
            super(view);
            rv = view.findViewById(R.id.rv_home_cat);
            title = view.findViewById(R.id.tv_home_title);
            viewAll = view.findViewById(R.id.ll_home_view_all);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv.setLayoutManager(linearLayoutManager);
            rv.setItemAnimator(new DefaultItemAnimator());
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {

        @SuppressLint("StaticFieldLeak")
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_CATEGORIES) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CategoriesHolder(itemView);
        } else if (viewType == VIEW_COUNTRIES) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CountriesHolder(itemView);
        } else if (viewType == VIEW_PODCASTS) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new PodcastsHolder(itemView);
        } else if (viewType == VIEW_RADIO) {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.layout_home_ui_categories, parent, false);
            return new RadiosHolder(itemView);
        } else {
            View v = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof CategoriesHolder categoriesHolder) {

            categoriesHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            categoriesHolder.adapterHomeCategories = new AdapterHomeCategories(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCategories());
            categoriesHolder.rv.setAdapter(categoriesHolder.adapterHomeCategories);
            categoriesHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.categories));
            }));

            categoriesHolder.viewAll.setOnClickListener(v -> {
                FragmentCategories albums = new FragmentCategories();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, albums, context.getString(R.string.categories));
                ft.addToBackStack(context.getString(R.string.categories));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.categories));
                ((MainActivity) context).bottomNavigationView(3);
            });
        }
        else if (holder instanceof CountriesHolder countriesHolder) {

            countriesHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            countriesHolder.adapterHomeCountries = new AdapterHomeCountries(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCountries());
            countriesHolder.rv.setAdapter(countriesHolder.adapterHomeCountries);
            countriesHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.countries));
            }));

            countriesHolder.viewAll.setOnClickListener(v -> {
                FragmentCountries countries = new FragmentCountries();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, countries, context.getString(R.string.countries));
                ft.addToBackStack(context.getString(R.string.countries));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.countries));
                ((MainActivity) context).bottomNavigationView(5);
            });
        }
        else if (holder instanceof PodcastsHolder podcastsHolder) {

            podcastsHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            podcastsHolder.adapterHomePodcasts = new AdapterHomePodcasts(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListPodcasts());
            podcastsHolder.rv.setAdapter(podcastsHolder.adapterHomePodcasts);
            podcastsHolder.rv.addOnItemTouchListener(new RecyclerItemClickListener(context, (view, position1) -> {
                clickPos = holder.getAbsoluteAdapterPosition();
                helper.showInterAd(position1, context.getString(R.string.podcasts));
            }));

            podcastsHolder.viewAll.setOnClickListener(v -> {
                FragmentCountries podcasts = new FragmentCountries();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, podcasts, context.getString(R.string.podcasts));
                ft.addToBackStack(context.getString(R.string.podcasts));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.podcasts));
                ((MainActivity) context).bottomNavigationView(5);
            });
        }
        else if (holder instanceof RadiosHolder radiosHolder && (adapterHomeRadio == null)){
            radiosHolder.title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            adapterHomeRadio = new AdapterHomeTrending(context,
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio(), false,
                    new AdapterHomeTrending.RecyclerItemClickListener() {
                @Override
                public void onClick(int position) {
                    if (NetworkUtils.isConnected(context)) {
                        Callback.setIsRadio(true);
                        String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                        if (!Callback.getAddedFrom().equals(addedFrom)) {
                            Callback.getArrayListPlay().clear();
                            Callback.setArrayListPlay(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                            Callback.setAddedFrom(addedFrom);
                            Callback.setIsNewAdded(true);
                        }
                        Callback.setPlayPos(position);
                        helper.showInterAd(position, context.getString(R.string.radio));
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }

                @Override
                public void onRewardAds(int position) {
                    if (spHelper.getRewardCredit() != 0){
                        spHelper.useRewardCredit(1);
                        if (NetworkUtils.isConnected(context)) {
                            Callback.setIsRadio(true);
                            String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                            if (!Callback.getAddedFrom().equals(addedFrom)) {
                                Callback.getArrayListPlay().clear();
                                Callback.setArrayListPlay(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                Callback.setAddedFrom(addedFrom);
                                Callback.setIsNewAdded(true);
                            }
                            Callback.setPlayPos(position);
                            helper.showInterAd(position, context.getString(R.string.radio));
                            Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        helper.showRewardAds(position, new RewardAdListener() {
                            @Override
                            public void onClick(boolean isLoad, int pos) {
                                if (isLoad){
                                    spHelper.addRewardCredit(Callback.getRewardCredit());
                                    spHelper.useRewardCredit(1);
                                    if (NetworkUtils.isConnected(context)) {
                                        Callback.setIsRadio(true);
                                        String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                                        if (!Callback.getAddedFrom().equals(addedFrom)) {
                                            Callback.getArrayListPlay().clear();
                                            Callback.setArrayListPlay(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                            Callback.setAddedFrom(addedFrom);
                                            Callback.setIsNewAdded(true);
                                        }
                                        Callback.setPlayPos(position);
                                        helper.showInterAd(position, context.getString(R.string.radio));
                                        Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                    } else {
                                        Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                    }
                                } else {
                                    Toast.makeText(context, "Display Failed", Toast.LENGTH_SHORT).show();
                                }
                            }

                            @Override
                            public void onPurchases(int pos) {
                                if (NetworkUtils.isConnected(context)) {
                                    Callback.setIsRadio(true);
                                    String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                                    if (!Callback.getAddedFrom().equals(addedFrom)) {
                                        Callback.getArrayListPlay().clear();
                                        Callback.setArrayListPlay(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListRadio());
                                        Callback.setAddedFrom(addedFrom);
                                        Callback.setIsNewAdded(true);
                                    }
                                    Callback.setPlayPos(position);
                                    helper.showInterAd(position, context.getString(R.string.radio));
                                    Toast.makeText(context, TAG_CREDIT+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                } else {
                                    Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                                }
                            }
                        });
                    }
                }
            });
            radiosHolder.rv.setAdapter(adapterHomeRadio);

            radiosHolder.viewAll.setOnClickListener(v -> {
                FragmentLatest latest = new FragmentLatest();
                FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                        .getFragments()
                        .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, latest, context.getString(R.string.latest));
                ft.addToBackStack(context.getString(R.string.latest));
                ft.commit();
                Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setTitle(context.getString(R.string.latest));
                ((MainActivity) context).bottomNavigationView(1);
            });
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void hideHeader() {
        ProgressViewHolder.progressBar.setVisibility(View.GONE);
    }

    public boolean isHeader(int position) {
        return arrayList.get(position) == null;
    }

    @SuppressLint("NotifyDataSetChanged")
    public void onEqualizerChange() {
        try {
            if (adapterHomeRadio != null){
                adapterHomeRadio.notifyDataSetChanged();
            }
        } catch (Exception e) {
            Log.e("AdapterSearch","Error onEqualizerChange" ,e);
        }
    }

    @Override
    public int getItemViewType(int position) {
        String type = arrayList.get(position).getType();
        int viewType;
        switch (type) {
            case "radio" -> viewType = VIEW_RADIO;
            case "countries" -> viewType = VIEW_COUNTRIES;
            case "podcasts" -> viewType = VIEW_PODCASTS;
            case "category" -> viewType = VIEW_CATEGORIES;
            default -> viewType = VIEW_PROG;
        }
        return viewType;
    }


    InterAdListener interAdListener = (position, type) -> {
        if (type.equals(context.getString(R.string.radio))) {
            Intent intent = new Intent(context, PlayerService.class);
            intent.setAction(PlayerService.ACTION_PLAY);
            context.startService(intent);
        } else if (type.equals(context.getString(R.string.categories))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.categories));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCategories().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCategories().get(position).name());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.countries))) {
            Intent intent = new Intent(context, RadioByActivity.class);
            intent.putExtra("type", context.getString(R.string.countries));
            intent.putExtra("id", arrayList.get(clickPos).getArrayListCountries().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListCountries().get(position).name());
            context.startActivity(intent);
        } else if (type.equals(context.getString(R.string.podcasts))) {
            Intent intent = new Intent(context, PodcastsByActivity.class);
            intent.putExtra("id", arrayList.get(clickPos).getArrayListPodcasts().get(position).id());
            intent.putExtra("name", arrayList.get(clickPos).getArrayListPodcasts().get(position).name());
            context.startActivity(intent);
        }
    };
}